<?php

namespace App\Controller;

use App\Action\Functions;
use App\Validation\ArrayValidation;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Attribute\Route;

class HomeController extends AbstractController
{
    private Functions $functions;

    public function __construct(Functions $functions)
    {
        $this->functions = $functions;
    }

    #[Route('/', name: 'home', methods: ['POST'])]
    public function home(Request $request): Response
    {
        $array = $request->get('arr');
        $errors = ArrayValidation::validate($array);
        if (count($errors) > 0) {
            return new Response((string)$errors);
        }
        $result = $this->functions->uniqElements($array);
        return $this->json($result);
    }
}
