<?php

namespace App\Controller;

use DateInterval;
use DatePeriod;
use DateTime;
use DateTimeImmutable;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Attribute\Route;

class HomeController extends AbstractController
{
    private function readFileLineByLine(string $fileName): iterable  {
        $filePath = $this->getParameter('kernel.project_dir') . "/public/files/" . $fileName;
        if (file_exists($filePath)) {
            $file = fopen($filePath, "r");
            while(!feof($file)) {
                yield fgets($file);
            }
            fclose($file);
        }
        else yield "Такого файла не существует.";
    }


    #[Route('/{fileName}', name: 'home')]
    public function home(string $fileName): Response // text.txt
    {
        $text = "";
        foreach($this->readFileLineByLine($fileName) as $line) {
            $text .= $line;
        }
        return $this->render('home.html.twig', ['text' => $text]);
    }
}
