<?php

namespace App\Entity;

use App\Repository\RestaurantRepository;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;
use Symfony\Component\Uid\Uuid;

#[ORM\Entity(repositoryClass: RestaurantRepository::class)]
class Restaurant
{
    #[ORM\Id]
    #[ORM\GeneratedValue]
    #[ORM\Column]
    private ?int $id = null;

    #[ORM\Column(type: 'uuid', unique: true)]
    private ?Uuid $uuid = null;

    #[ORM\Column(length: 255)]
    private ?string $name = null;

    #[ORM\Column(length: 255)]
    private ?string $code = null;

    #[ORM\Column]
    private ?bool $active = null;

    #[ORM\Column]
    private ?int $sort = null;

    #[ORM\Column(type: Types::DATETIME_MUTABLE)]
    private ?\DateTimeInterface $createAt = null;

    #[ORM\Column(type: Types::DATETIME_MUTABLE)]
    private ?\DateTimeInterface $updateAt = null;

    #[ORM\Column(type: Types::ARRAY)]
    private array $coordinates = [];

    #[ORM\ManyToOne(inversedBy: 'restaurants')]
    #[ORM\JoinColumn(nullable: false)]
    private ?RestaurantType $typeId = null;

    #[ORM\ManyToOne(inversedBy: 'restaurants')]
    #[ORM\JoinColumn(nullable: false)]
    private ?Settlement $settlementId = null;

    #[ORM\Column(type: Types::TEXT)]
    private ?string $description = null;

    #[ORM\Column(length: 255)]
    private ?string $checkPrice = null;

    #[ORM\Column(type: Types::TEXT)]
    private ?string $checkInfo = null;

    /**
     * @var Collection<int, Kitchen>
     */
    #[ORM\OneToMany(targetEntity: Kitchen::class, mappedBy: 'restaurant')]
    private Collection $kitchen;

    /**
     * @var Collection<int, Phone>
     */
    #[ORM\OneToMany(targetEntity: Phone::class, mappedBy: 'restaurant')]
    private Collection $phone;

    /**
     * @var Collection<int, Email>
     */
    #[ORM\OneToMany(targetEntity: Email::class, mappedBy: 'restaurant')]
    private Collection $email;

    /**
     * @var Collection<int, Address>
     */
    #[ORM\OneToMany(targetEntity: Address::class, mappedBy: 'restaurant')]
    private Collection $address;

    /**
     * @var Collection<int, Tags>
     */
    #[ORM\OneToMany(targetEntity: Tags::class, mappedBy: 'restaurant')]
    private Collection $tags;

    #[ORM\Column(length: 255)]
    private ?string $site = null;

    #[ORM\Column(length: 255)]
    private ?string $previewImage = null;

    #[ORM\Column(length: 255)]
    private ?string $detailImage = null;

    #[ORM\Column(type: Types::TEXT)]
    private ?string $howToFind = null;

    public function __construct()
    {
        $this->kitchen = new ArrayCollection();
        $this->phone = new ArrayCollection();
        $this->email = new ArrayCollection();
        $this->address = new ArrayCollection();
        $this->tags = new ArrayCollection();
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getUuid(): ?Uuid
    {
        return $this->uuid;
    }

    public function setUuid(Uuid $uuid): static
    {
        $this->uuid = $uuid;

        return $this;
    }

    public function getName(): ?string
    {
        return $this->name;
    }

    public function setName(string $name): static
    {
        $this->name = $name;

        return $this;
    }

    public function getCode(): ?string
    {
        return $this->code;
    }

    public function setCode(string $code): static
    {
        $this->code = $code;

        return $this;
    }

    public function isActive(): ?bool
    {
        return $this->active;
    }

    public function setActive(bool $active): static
    {
        $this->active = $active;

        return $this;
    }

    public function getSort(): ?int
    {
        return $this->sort;
    }

    public function setSort(int $sort): static
    {
        $this->sort = $sort;

        return $this;
    }

    public function getCreateAt(): ?\DateTimeInterface
    {
        return $this->createAt;
    }

    public function setCreateAt(\DateTimeInterface $createAt): static
    {
        $this->createAt = $createAt;

        return $this;
    }

    public function getUpdateAt(): ?\DateTimeInterface
    {
        return $this->updateAt;
    }

    public function setUpdateAt(\DateTimeInterface $updateAt): static
    {
        $this->updateAt = $updateAt;

        return $this;
    }

    public function getCoordinates(): array
    {
        return $this->coordinates;
    }

    public function setCoordinates(array $coordinates): static
    {
        $this->coordinates = $coordinates;

        return $this;
    }

    public function getTypeId(): ?RestaurantType
    {
        return $this->typeId;
    }

    public function setTypeId(?RestaurantType $typeId): static
    {
        $this->typeId = $typeId;

        return $this;
    }

    public function getSettlementId(): ?Settlement
    {
        return $this->settlementId;
    }

    public function setSettlementId(?Settlement $settlementId): static
    {
        $this->settlementId = $settlementId;

        return $this;
    }

    public function getDescription(): ?string
    {
        return $this->description;
    }

    public function setDescription(string $description): static
    {
        $this->description = $description;

        return $this;
    }

    public function getCheckPrice(): ?string
    {
        return $this->checkPrice;
    }

    public function setCheckPrice(string $checkPrice): static
    {
        $this->checkPrice = $checkPrice;

        return $this;
    }

    public function getCheckInfo(): ?string
    {
        return $this->checkInfo;
    }

    public function setCheckInfo(string $checkInfo): static
    {
        $this->checkInfo = $checkInfo;

        return $this;
    }

    /**
     * @return Collection<int, Kitchen>
     */
    public function getKitchen(): Collection
    {
        return $this->kitchen;
    }

    public function addKitchen(Kitchen $kitchen): static
    {
        if (!$this->kitchen->contains($kitchen)) {
            $this->kitchen->add($kitchen);
            $kitchen->setRestaurant($this);
        }

        return $this;
    }

    public function removeKitchen(Kitchen $kitchen): static
    {
        if ($this->kitchen->removeElement($kitchen)) {
            // set the owning side to null (unless already changed)
            if ($kitchen->getRestaurant() === $this) {
                $kitchen->setRestaurant(null);
            }
        }

        return $this;
    }

    /**
     * @return Collection<int, Phone>
     */
    public function getPhone(): Collection
    {
        return $this->phone;
    }

    public function addPhone(Phone $phone): static
    {
        if (!$this->phone->contains($phone)) {
            $this->phone->add($phone);
            $phone->setRestaurant($this);
        }

        return $this;
    }

    public function removePhone(Phone $phone): static
    {
        if ($this->phone->removeElement($phone)) {
            // set the owning side to null (unless already changed)
            if ($phone->getRestaurant() === $this) {
                $phone->setRestaurant(null);
            }
        }

        return $this;
    }

    /**
     * @return Collection<int, Email>
     */
    public function getEmail(): Collection
    {
        return $this->email;
    }

    public function addEmail(Email $email): static
    {
        if (!$this->email->contains($email)) {
            $this->email->add($email);
            $email->setRestaurant($this);
        }

        return $this;
    }

    public function removeEmail(Email $email): static
    {
        if ($this->email->removeElement($email)) {
            // set the owning side to null (unless already changed)
            if ($email->getRestaurant() === $this) {
                $email->setRestaurant(null);
            }
        }

        return $this;
    }

    /**
     * @return Collection<int, Address>
     */
    public function getAddress(): Collection
    {
        return $this->address;
    }

    public function addAddress(Address $address): static
    {
        if (!$this->address->contains($address)) {
            $this->address->add($address);
            $address->setRestaurant($this);
        }

        return $this;
    }

    public function removeAddress(Address $address): static
    {
        if ($this->address->removeElement($address)) {
            // set the owning side to null (unless already changed)
            if ($address->getRestaurant() === $this) {
                $address->setRestaurant(null);
            }
        }

        return $this;
    }

    /**
     * @return Collection<int, Tags>
     */
    public function getTags(): Collection
    {
        return $this->tags;
    }

    public function addTag(Tags $tag): static
    {
        if (!$this->tags->contains($tag)) {
            $this->tags->add($tag);
            $tag->setRestaurant($this);
        }

        return $this;
    }

    public function removeTag(Tags $tag): static
    {
        if ($this->tags->removeElement($tag)) {
            // set the owning side to null (unless already changed)
            if ($tag->getRestaurant() === $this) {
                $tag->setRestaurant(null);
            }
        }

        return $this;
    }

    public function getSite(): ?string
    {
        return $this->site;
    }

    public function setSite(string $site): static
    {
        $this->site = $site;

        return $this;
    }

    public function getPreviewImage(): ?string
    {
        return $this->previewImage;
    }

    public function setPreviewImage(string $previewImage): static
    {
        $this->previewImage = $previewImage;

        return $this;
    }

    public function getDetailImage(): ?string
    {
        return $this->detailImage;
    }

    public function setDetailImage(string $detailImage): static
    {
        $this->detailImage = $detailImage;

        return $this;
    }

    public function getHowToFind(): ?string
    {
        return $this->howToFind;
    }

    public function setHowToFind(string $howToFind): static
    {
        $this->howToFind = $howToFind;

        return $this;
    }
}
