<?php

namespace App\Controller;

use App\Action\Functions;
use App\Validation\ArrayValidation;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\Routing\Attribute\Route;

class HomeController extends AbstractController
{
    private Functions $functions;

    public function __construct(Functions $functions)
    {
        $this->functions = $functions;
    }

    #[Route('/func1', name: 'home', methods: ['POST'])]
    public function func1(Request $request): Response
    {
        $array = $request->get('arr');
        if (!ArrayValidation::validateFunc1($array)) {
            return new Response("Invalid array");
        }
        $array = $this->functions->sortPrice($array);
        return $this->json($array);
    }

    #[Route('/func2', name: 'func2', methods: ['POST'])]
    public function func2(Request $request): Response
    {
        $id = $request->query->getInt('id');
        $array = $request->get('arr');
        if (!ArrayValidation::validateFunc2($array)) {
            return new Response("Invalid array");
        }
        $result = $this->functions->search($array, $id);
        return $this->json($result);
    }

    #[Route('/func3', name: 'home', methods: ['POST'])]
    public function home(Request $request): Response
    {
        $array = $request->get('arr');
        $result = $this->functions->uniqElements($array);
        return $this->json($result);
    }

    #[Route('/func4', name: 'home', methods: ['POST'])]
    public function func4(Request $request): Response
    {
        $array = $request->get('arr');
        if (!ArrayValidation::validateFunc4($array)) {
            return new Response("Invalid array");
        }
        $result = $this->functions->prepareMenu($array);
        return $this->json($result);
    }

    #[Route('/{day}/{month}/{year}', name: 'home')]
    public function home(int $day, int $month, int $year): Response
    {
        $dateAsString = $year . "-" . $month . "-" . $day;
        try {
            $result = $this->functions->howDaysToNy(new DateTimeImmutable($dateAsString));
        } catch (\Exception $e) {
            return new Response($e->getMessage());
        }
        return $this->json(["Days before NY:" => $result]);
    }
}
