<?php

require_once __DIR__ . '/../vendor/autoload.php';

use App\Actions\ReadLogFileAction;
use App\Actions\UniqElementsAction;
use App\Actions\DiffDaysAction;
use App\Actions\CountFriday13;
use App\Actions\HowDaysToNYAction;
use App\Actions\SortPriceAction;
use App\Actions\IdSearchAction;
use App\Actions\ReadFileLineByLineAction;
use App\Actions\PrepareMenuAction;
use App\TestData\TestData;

echo 'ReadFileLineByLineAction: <br>';
try {
    foreach (ReadFileLineByLineAction::read(TestData::FILE_PATH) as $line) {
        echo $line;
    }
echo '<hr>';

echo 'ReadLogFileAction: <br>';
try {
    ReadLogFileAction::read(TestData::FILE_PATH);
} catch (Exception $ex) {
    echo $ex->getMessage();
}
echo '<hr>';

echo 'UniqElementsAction: <br>';
var_dump(UniqElementsAction::uniqElements(TestData::NON_UNIQE_ARRAY));
echo '<hr>';

echo 'IdSearchAction: <br>';
var_dump(IdSearchAction::search(TestData::ARRAY_FOR_SEARCHING));
echo '<hr>';

echo 'PrepareMenuAction: <br>';
var_dump(PrepareMenuAction::prepare(TestData::RAW_MENU));
echo '<hr>'

echo 'DiffDaysAction <br>'
var_dump(DiffDaysAction::count(
    new DateTimeImmutable(TestData::START_DATE),
    new DateTimeImmutable(TestData::END_DATE)
));
echo '<hr>';

echo 'HowDaysToNYAction: <br>';
echo "Дней до нового года (в днях): ". HowDaysToNYAction::count(new DateTimeImmutable());
echo '<hr>';

echo 'SortPriceAction: <br>';
var_dump(SortPriceAction::sort(TestData::PRICE_COUNT_ARRAY));
echo '<hr>';

echo 'CountFriday13: <br>';
var_dump(CountFriday13::count(TestData::YEAR));
echo '<hr>';
