<?php

namespace App\Actions;

use Exception;

class ReadLogFileAction
{
    /**
     * Принимает путь до файла,
     * проверяет, что файл существует и выводит пользователю весь контент файла
     * (файл можешь создать любой)
     *
     * @param string $filePath путь до файла
     * @return void
     * @throws Exception при отсутсвии фаила по переданному пути
     */
    public static function read(string $filePath): void
    {
        if (!file_exists($filePath)) {
            throw new Exception("По данному пути ничего не найдено: $filePath");
        }

        echo file_get_contents($filePath);
    }
}
