<?php

namespace App\Actions;

use Generator;

class ReadFileLineByLineAction
{
    /**
     * Принимает путь до файла,
     * проверяет, что файл существует и выводит пользователю построчный вывод используя yield
     * (файл можешь создать любой)
     *
     * @param string $filePath путь до файла
     * @return string|Generator  */
    public static function read(string $filePath): Generator
    {
        if (!file_exists($filePath)) {
            throw new Exception("неверный путь");
        }

        $file = fopen($filePath, 'r');
        while (!feof($file)) {
            yield fgets($file);
        }

        fclose($file);
    }
}
