<?php

namespace App\Actions;

class PrepareMenuAction
{
    /**
     * Группирует подразедлы в верхние разделы меню
     * Дочерние элементы помещает в массив родителя с ключом submenu
     * Значение под ключом depth определяет уровень раздела
     * Массив $aMenu всегда должен начинается с элемента depth = 0,
     * все последующие элементы с depth = 1 являются его дочерними элементами
     *
     * @param array $aMenu
     * @return array
     */
    public static function prepare(array $aMenu): array
    {
        $returnableAMenu = [];
        foreach ($aMenu as $menuPoint) {

            $depth = $menuPoint["depth"];

            if ($depth === 1) {
                $tempArray = array_pop($returnableAMenu);
                $tempArray['submenu'][] = $menuPoint;
                $returnableAMenu[] = $tempArray;
            } else {
                $returnableAMenu[] = $menuPoint;
            }
        }

        return $returnableAMenu;
    }
}
