<?php

namespace App\Restaurants\UseCase;

use App\Restaurants\Request\RestaurantCreateRequest;
use App\Restaurants\Service\RestaurantPrepareResponseService;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\Response;
use Throwable;

class RestaurantCreateUseCase
{
    public function __construct(
        private readonly RestaurantPrepareResponseService $prepareRequestService,
    ) {
    }

    public function execute(RestaurantCreateRequest $request): Response
    {
        try {
            $this->prepareRequestService->birth($request);
            return new Response();
        } catch (Throwable) {
            return new JsonResponse([], Response::HTTP_INTERNAL_SERVER_ERROR);
        }
    }
}
