<?php

namespace App\Restaurants\Controller;

use App\Restaurants\Request\RestaurantCreateRequest;
use App\Restaurants\Request\RestaurantFullUpdateRequest;
use App\Restaurants\Request\RestaurantPartUpdateRequest;
use App\Restaurants\UseCase\RestaurantCreateUseCase;
use App\Restaurants\UseCase\RestaurantDeleteUseCase;
use App\Restaurants\UseCase\RestaurantFullUpdateUseCase;
use App\Restaurants\UseCase\RestaurantGetListingUseCase;
use App\Restaurants\Request\RestaurantDetailRequest;
use App\Restaurants\Request\RestaurantListingRequest;
use App\Restaurants\UseCase\RestaurantGetDetailUseCase;
use App\Restaurants\UseCase\RestaurantPartUpdateUseCase;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Attribute\Route;

#[Route('/api/v1/restaurants')]
class RestaurantsController extends AbstractController
{
    public function __construct(
        private readonly RestaurantGetListingUseCase $getListingUseCase,
        private readonly RestaurantGetDetailUseCase $getDetailUseCase,
        private readonly RestaurantCreateUseCase $createUseCase,
        private readonly RestaurantFullUpdateUseCase $fullUpdateUseCase,
        private readonly RestaurantDeleteUseCase $deleteUseCase,
        private readonly RestaurantPartUpdateUseCase $partUpdateUseCase,
    ) {
    }

    #[Route('/', name: 'restaurants', methods: ['GET'])]
    public function restaurants(RestaurantListingRequest $request): JsonResponse
    {
        return $this->getListingUseCase->execute($request);
    }

    #[Route('/{detailId}', name: 'restaurant', methods: ['GET'])]
    public function restaurant(RestaurantDetailRequest $request): JsonResponse
    {
        return $this->getDetailUseCase->execute($request);
    }

    #[Route('/create', name: 'createRestaurant', methods: ['POST'])]
    public function createRestaurant(RestaurantCreateRequest $request): Response
    {
        return $this->createUseCase->execute($request);
    }

    #[Route('/update', name: 'updateRestaurant', methods: ['PUT'])]
    public function fillUpdateRestaurant(RestaurantFullUpdateRequest $request
    ): Response {
        return $this->fullUpdateUseCase->execute($request);
    }

    #[Route('/partUpdate', name: 'partUpdateRestaurant', methods: ['PATCH'])]
    public function partUpdateRestaurant(RestaurantPartUpdateRequest $request
    ): Response {
        return $this->partUpdateUseCase->execute($request);
    }

    #[Route('/delete/{detailId}', name: 'deleteRestaurant', methods: ['DELETE'])]
    public function deleteRestaurant(RestaurantDetailRequest $request): Response
    {
        return $this->deleteUseCase->execute($request);
    }
}
