<?php

namespace App\News\UseCase;

use App\News\Request\NewsDetailRequest;
use App\News\Service\NewsPrepareResponseService;
use App\Shared\DtoFactory\ErrorDtoFactory;
use App\Shared\Error\NotFoundError;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\Response;
use Throwable;

class NewsGetDetailUseCase
{
    public function __construct(
        private readonly NewsPrepareResponseService $responsePrepareService,
        private readonly ErrorDtoFactory $errorFactory,
    ) {
    }

    public function execute(NewsDetailRequest $request): JsonResponse
    {
        try {
            return new JsonResponse(
                $this->responsePrepareService->bornDetail($request)
            );
        } catch (NotFoundError $error) {
            $errorDto = $this->errorFactory->create($error);
            return new JsonResponse($errorDto, $errorDto->status);
        } catch (Throwable) {
            return new JsonResponse([], Response::HTTP_INTERNAL_SERVER_ERROR);
        }
    }
}