<?php

namespace App\Shared\Service;

class ValidationService
{
    public function isUuidValid(?string $uuid): bool
    {
        if ($uuid === null) {
            return false;
        }

        if (preg_match('/^[a-f\d]{8}(-[a-f\d]{4}){4}[a-f\d]{8}$/i', $uuid) !== 1) {
            return false;
        }

        return true;
    }

    public function isPageValid(int $page): bool
    {
        return $page >= 1;
    }

    public function isLimitValid(int $limit): bool
    {
        return $limit >= 1;
    }
}
