<?php

namespace App\Restaurants\UseCase;

use App\Restaurants\Request\RestaurantDetailRequest;
use App\Restaurants\Service\RestaurantPrepareRequestService;
use App\Shared\DtoFactory\ErrorDtoFactory;
use App\Shared\Error\NotFoundError;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\Response;
use Throwable;

class RestaurantGetDetailUseCase
{
    public function __construct(
        private readonly RestaurantPrepareRequestService $responsePrepareService,
        private readonly ErrorDtoFactory $errorFactory,
    ) {
    }

    public function execute(RestaurantDetailRequest $request): JsonResponse
    {
        try {
            return new JsonResponse(
                $this->responsePrepareService->bornDetailElement($request)
            );
        } catch (NotFoundError $error) {
            $errorDto = $this->errorFactory->create($error);
            return new JsonResponse($errorDto, $errorDto->status);
        } catch (Throwable) {
            return new JsonResponse([], Response::HTTP_INTERNAL_SERVER_ERROR);
        }
    }
}