<?php

namespace App\Restaurants\DtoFactory;

use App\Restaurants\Collection\KitchenCollection;
use App\Restaurants\Dto\KitchenTypeDto;
use App\Shared\Entity\Kitchens;
use Doctrine\Common\Collections\Collection as DoctrineCollection;
use Ramsey\Collection\Collection as RamseyCollection;

class KitchenTypeDtoFactory
{
    public function create(Kitchens $kitchen): KitchenTypeDto
    {
        return new KitchenTypeDto(
            id: $kitchen->getId(),
            name: $kitchen->getName(),
            code: $kitchen->getCode(),
        );
    }

    /**
     * @param DoctrineCollection<Kitchens>|RamseyCollection<Kitchens> $kitchens
     * @return KitchenCollection<KitchenTypeDto>
     */
    public function createCollection(
        DoctrineCollection|RamseyCollection $kitchens
    ): KitchenCollection {
        $kitchenCollection = $kitchens->map(function (Kitchens $kitchen) {
            return $this->create($kitchen);
        });

        return new KitchenCollection($kitchenCollection->toArray());
    }
}
