<?php

namespace App\News\UseCase;

use App\News\Service\NewsPrepareResponseService;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\Response;
use Throwable;

class NewsGetDetailMainUseCase
{
    public function __construct(
        private readonly NewsPrepareResponseService $prepareRequestService,
    ) {
    }

    public function execute(): ?JsonResponse
    {
        try {
            return new JsonResponse(
                $this->prepareRequestService->bornDetailMainNews()
            );
        } catch (Throwable) {
            return new JsonResponse([], Response::HTTP_INTERNAL_SERVER_ERROR);
        }
    }
}