<?php

namespace App\Entity;

use App\Dto\DtoInterface;
use App\Dto\NewsDetailElementDto;
use App\Dto\NewsListingElementDto;
use App\Repository\NewsRepository;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Entity(repositoryClass: NewsRepository::class)]
class News implements PrototypeElementDto
{
    #[ORM\Id]
    #[ORM\Column(type: Types::GUID)]
    private ?string $id = null;

    #[ORM\Column(length: 255)]
    private ?string $name = null;

    #[ORM\Column(length: 255)]
    private ?string $code = null;

    #[ORM\Column]
    private ?int $sort = null;

    #[ORM\Column]
    private ?bool $active = null;

    #[ORM\Column]
    private ?\DateTimeImmutable $createdAt = null;

    #[ORM\Column]
    private ?\DateTimeImmutable $updateAt = null;

    #[ORM\Column(length: 1000, nullable: true)]
    private ?string $previewText = null;

    #[ORM\Column(length: 255, nullable: true)]
    private ?string $detailText = null;

    #[ORM\ManyToOne(inversedBy: 'news')]
    private ?NewsType $type = null;

    /**
     * @var Collection<int, NewsCategories>
     */
    #[ORM\ManyToMany(targetEntity: NewsCategories::class, inversedBy: 'news')]
    private Collection $categories;

    #[ORM\Column]
    private ?bool $mainPageRender = null;

    #[ORM\ManyToOne(inversedBy: 'newsDetail')]
    private ?File $detailImage = null;

    #[ORM\ManyToOne(inversedBy: 'newsPreview')]
    private ?File $previewImage = null;


    public function __construct()
    {
        $this->categories = new ArrayCollection();
    }

    public function getId(): ?string
    {
        return $this->id;
    }

    public function setId(string $id): static
    {
        $this->id = $id;

        return $this;
    }

    public function getName(): ?string
    {
        return $this->name;
    }

    public function setName(string $name): static
    {
        $this->name = $name;

        return $this;
    }

    public function getCode(): ?string
    {
        return $this->code;
    }

    public function setCode(string $code): static
    {
        $this->code = $code;

        return $this;
    }

    public function getSort(): ?int
    {
        return $this->sort;
    }

    public function setSort(int $sort): static
    {
        $this->sort = $sort;

        return $this;
    }

    public function isActive(): ?bool
    {
        return $this->active;
    }

    public function setActive(bool $active): static
    {
        $this->active = $active;

        return $this;
    }

    public function getCreatedAt(): ?\DateTimeImmutable
    {
        return $this->createdAt;
    }

    public function setCreatedAt(\DateTimeImmutable $createdAt): static
    {
        $this->createdAt = $createdAt;

        return $this;
    }

    public function getUpdateAt(): ?\DateTimeImmutable
    {
        return $this->updateAt;
    }

    public function setUpdateAt(\DateTimeImmutable $updateAt): static
    {
        $this->updateAt = $updateAt;

        return $this;
    }

    public function getPreviewImage(): ?File
    {
        return $this->previewImage;
    }

    public function setPreviewImage(?File $previewImage): static
    {
        $this->previewImage = $previewImage;

        return $this;
    }

    public function getPreviewText(): ?string
    {
        return $this->previewText;
    }

    public function setPreviewText(?string $previewText): static
    {
        $this->previewText = $previewText;

        return $this;
    }

    public function getDetailImage(): ?File
    {
        return $this->detailImage;
    }

    public function setDetailImage(?File $detailImage): static
    {
        $this->detailImage = $detailImage;

        return $this;
    }

    public function getDetailText(): ?string
    {
        return $this->detailText;
    }

    public function setDetailText(?string $detailText): static
    {
        $this->detailText = $detailText;

        return $this;
    }

    public function getType(): ?NewsType
    {
        return $this->type;
    }

    public function setType(?NewsType $type): static
    {
        $this->type = $type;

        return $this;
    }

    /**
     * @return Collection<int, NewsCategories>
     */
    public function getCategories(): Collection
    {
        return $this->categories;
    }

    public function addCategory(NewsCategories $category): static
    {
        if (!$this->categories->contains($category)) {
            $this->categories->add($category);
        }

        return $this;
    }

    public function removeCategory(NewsCategories $category): static
    {
        $this->categories->removeElement($category);

        return $this;
    }

    public function isMainPageRender(): ?bool
    {
        return $this->mainPageRender;
    }

    public function setMainPageRender(bool $mainPageRender): static
    {
        $this->mainPageRender = $mainPageRender;

        return $this;
    }

    /** @inheritDoc */
    public function getDto(): DtoInterface
    {
        $entity = new NewsListingElementDto();

        $entity->id = $this->getId();
        $entity->name = $this->getName();
        $entity->description = $this->getDetailText();
        $entity->image = $this->getPreviewImage()?->getDto();
        $entity->create_at = $this->getCreatedAt()->format('Y-m-d H:i:s');
        $entity->detail_link = "api/v1/restaurants/" . $this->getId();

        return $entity;
    }

    /** @inheritDoc */
    public function getExtendedDto(): DtoInterface
    {
        $entity = new NewsDetailElementDto();

        $entity->id = $this->getId();
        $entity->name = $this->getName();
        $entity->description = $this->getPreviewText();
        $entity->text = $this->getDetailText();
        $entity->image = $this->getPreviewImage()?->getDto();
        $entity->create_at = $this->getCreatedAt()->format('Y-m-d H:i:s');

        return $entity;
    }
}
