<?php

namespace App\Entity;

use App\Dto\DtoInterface;
use App\Dto\FileDto;
use App\Repository\FileRepository;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Entity(repositoryClass: FileRepository::class)]
class File implements PrototypeDto
{
    #[ORM\Id]
    #[ORM\Column(type: Types::GUID)]
    private ?string $id = null;

    #[ORM\Column(length: 255)]
    private ?string $name = null;

    #[ORM\Column(length: 255)]
    private ?string $description = null;

    #[ORM\Column]
    private ?int $size = null;

    #[ORM\Column(length: 255)]
    private ?string $type = null;

    #[ORM\Column(length: 255)]
    private ?string $url = null;

    /**
     * @var Collection<int, Restaurants>
     */
    #[ORM\OneToMany(targetEntity: Restaurants::class, mappedBy: 'previewImage')]
    private Collection $restaurantsPreview;

    /**
     * @var Collection<int, Restaurants>
     */
    #[ORM\OneToMany(targetEntity: Restaurants::class, mappedBy: 'detailImage')]
    private Collection $restaurantsDetail;

    /**
     * @var Collection<int, Restaurants>
     */
    #[ORM\ManyToMany(targetEntity: Restaurants::class, mappedBy: 'gallery')]
    private Collection $restaurantsGallery;

    /**
     * @var Collection<int, News>
     */
    #[ORM\OneToMany(targetEntity: News::class, mappedBy: 'detailImage')]

    private Collection $newsDetail;

    /**
     * @var Collection<int, News>
     */
    #[ORM\OneToMany(targetEntity: News::class, mappedBy: 'previewImage')]
    private Collection $newsPreview;

    public function __construct()
    {
        $this->restaurantsPreview = new ArrayCollection();
        $this->restaurantsDetail = new ArrayCollection();
        $this->restaurantsGallery = new ArrayCollection();
        $this->newsDetail = new ArrayCollection();
        $this->newsPreview = new ArrayCollection();
    }

    public function getId(): ?string
    {
        return $this->id;
    }

    public function setId(string $id): static
    {
        $this->id = $id;

        return $this;
    }

    public function getName(): ?string
    {
        return $this->name;
    }

    public function setName(string $name): static
    {
        $this->name = $name;

        return $this;
    }

    public function getDescription(): ?string
    {
        return $this->description;
    }

    public function setDescription(string $description): static
    {
        $this->description = $description;

        return $this;
    }

    public function getSize(): ?int
    {
        return $this->size;
    }

    public function setSize(int $size): static
    {
        $this->size = $size;

        return $this;
    }

    public function getType(): ?string
    {
        return $this->type;
    }

    public function setType(string $type): static
    {
        $this->type = $type;

        return $this;
    }

    public function getUrl(): ?string
    {
        return $this->url;
    }

    public function setUrl(string $url): static
    {
        $this->url = $url;

        return $this;
    }

    /**
     * @return Collection<int, Restaurants>
     */
    public function getRestaurantsPreview(): Collection
    {
        return $this->restaurantsPreview;
    }

    public function addRestaurantsPreview(Restaurants $restaurantsPreview): static
    {
        if (!$this->restaurantsPreview->contains($restaurantsPreview)) {
            $this->restaurantsPreview->add($restaurantsPreview);
            $restaurantsPreview->setPreviewImage($this);
        }

        return $this;
    }

    public function removeRestaurantsPreview(Restaurants $restaurantsPreview): static
    {
        if ($this->restaurantsPreview->removeElement($restaurantsPreview)) {
            // set the owning side to null (unless already changed)
            if ($restaurantsPreview->getPreviewImage() === $this) {
                $restaurantsPreview->setPreviewImage(null);
            }
        }

        return $this;
    }

    /**
     * @return Collection<int, Restaurants>
     */
    public function getRestaurantsDetail(): Collection
    {
        return $this->restaurantsDetail;
    }

    public function addRestaurantsDetail(Restaurants $restaurantsDetail): static
    {
        if (!$this->restaurantsDetail->contains($restaurantsDetail)) {
            $this->restaurantsDetail->add($restaurantsDetail);
            $restaurantsDetail->setDetailImage($this);
        }

        return $this;
    }

    public function removeRestaurantsDetail(Restaurants $restaurantsDetail): static
    {
        if ($this->restaurantsDetail->removeElement($restaurantsDetail)) {
            // set the owning side to null (unless already changed)
            if ($restaurantsDetail->getDetailImage() === $this) {
                $restaurantsDetail->setDetailImage(null);
            }
        }

        return $this;
    }

    /**
     * @return Collection<int, Restaurants>
     */
    public function getRestaurantsGallery(): Collection
    {
        return $this->restaurantsGallery;
    }

    public function addRestaurantsGallery(Restaurants $restaurantsGallery): static
    {
        if (!$this->restaurantsGallery->contains($restaurantsGallery)) {
            $this->restaurantsGallery->add($restaurantsGallery);
            $restaurantsGallery->addGallery($this);
        }

        return $this;
    }

    public function removeRestaurantsGallery(Restaurants $restaurantsGallery): static
    {
        if ($this->restaurantsGallery->removeElement($restaurantsGallery)) {
            $restaurantsGallery->removeGallery($this);
        }

        return $this;
    }

    /**
     * @return Collection<int, News>
     */
    public function getNewsDetail(): Collection
    {
        return $this->newsDetail;
    }

    public function addNewsDetail(News $newsDetail): static
    {
        if (!$this->newsDetail->contains($newsDetail)) {
            $this->newsDetail->add($newsDetail);
            $newsDetail->setDetailImage($this);
        }

        return $this;
    }

    public function removeNewsDetail(News $newsDetail): static
    {
        if ($this->newsDetail->removeElement($newsDetail)) {
            // set the owning side to null (unless already changed)
            if ($newsDetail->getDetailImage() === $this) {
                $newsDetail->setDetailImage(null);
            }
        }

        return $this;
    }

    /**
     * @return Collection<int, News>
     */
    public function getNewsPreview(): Collection
    {
        return $this->newsPreview;
    }

    public function addNewsPreview(News $newsPreview): static
    {
        if (!$this->newsPreview->contains($newsPreview)) {
            $this->newsPreview->add($newsPreview);
            $newsPreview->setPreviewImage($this);
        }

        return $this;
    }

    public function removeNewsPreview(News $newsPreview): static
    {
        if ($this->newsPreview->removeElement($newsPreview)) {
            // set the owning side to null (unless already changed)
            if ($newsPreview->getPreviewImage() === $this) {
                $newsPreview->setPreviewImage(null);
            }
        }

        return $this;
    }

    /** @inheritDoc */
    public function getDto(): FileDto
    {
        $dto =  new FileDto();

        $dto->id = $this->getId();
        $dto->name = $this->getName();
        $dto->description = $this->getDescription();
        $dto->size = $this->getSize();
        $dto->type = $this->getType();
        $dto->url = $this->getUrl();

        return $dto;
    }
}
