<?php

namespace App\Shared\Repository;

use App\Shared\Entity\RestaurantTypes;
use Doctrine\Bundle\DoctrineBundle\Repository\ServiceEntityRepository;
use Doctrine\Persistence\ManagerRegistry;
use Ramsey\Collection\Collection;

/**
 * @extends ServiceEntityRepository<RestaurantTypes>
 *
 * @method RestaurantTypes|null find($id, $lockMode = null, $lockVersion = null)
 * @method RestaurantTypes|null findOneBy(array $criteria, array $orderBy = null)
 * @method RestaurantTypes[]    findAll()
 * @method RestaurantTypes[]    findBy(array $criteria, array $orderBy = null, $limit = null, $offset = null)
 */
class RestaurantTypesRepository extends ServiceEntityRepository
{
    public function __construct(ManagerRegistry $registry)
    {
        parent::__construct($registry, RestaurantTypes::class);
    }

    /** @return Collection<RestaurantTypes> */
    public function getAll(): Collection
    {
        return new Collection(RestaurantTypes::class, $this->findAll());
    }
}
