<?php

namespace App\Shared\Repository;

use App\Shared\Entity\Kitchens;
use Doctrine\Bundle\DoctrineBundle\Repository\ServiceEntityRepository;
use Doctrine\Persistence\ManagerRegistry;
use Ramsey\Collection\Collection;

/**
 * @extends ServiceEntityRepository<Kitchens>
 *
 * @method Kitchens|null find($id, $lockMode = null, $lockVersion = null)
 * @method Kitchens|null findOneBy(array $criteria, array $orderBy = null)
 * @method Kitchens[]    findAll()
 * @method Kitchens[]    findBy(array $criteria, array $orderBy = null, $limit = null, $offset = null)
 */
class KitchensRepository extends ServiceEntityRepository
{
    public function __construct(ManagerRegistry $registry)
    {
        parent::__construct($registry, Kitchens::class);
    }

    /** @return Collection<Kitchens> */
    public function getAll(): Collection
    {
        return new Collection(Kitchens::class, $this->findAll());
    }
}
