<?php

namespace App\Shared\Entity;

use App\Shared\Repository\RestaurantsRepository;
use DateTimeImmutable;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Entity(repositoryClass: RestaurantsRepository::class)]
class Restaurants
{
    #[ORM\Id]
    #[ORM\Column(type: Types::GUID)]
    private ?string $id = null;

    #[ORM\Column]
    private ?bool $active = null;

    #[ORM\Column]
    private ?int $sort = null;

    #[ORM\Column]
    private ?DateTimeImmutable $createdAt = null;

    #[ORM\Column]
    private ?DateTimeImmutable $updateAt = null;

    #[ORM\ManyToOne(inversedBy: 'restaurantsTypes')]
    private ?RestaurantTypes $type = null;

    #[ORM\ManyToOne(inversedBy: 'restaurantsSettlements')]
    private ?Settlements $settlement = null;

    #[ORM\Column(length: 255)]
    private ?string $name = null;

    #[ORM\Column(length: 255)]
    private ?string $code = null;

    #[ORM\Column(length: 255)]
    private ?string $description = null;

    #[ORM\Column(length: 255)]
    private ?string $receipt = null;

    #[ORM\Column(length: 255)]
    private ?string $receiptInfo = null;

    #[ORM\Column(length: 255)]
    private ?string $phone = null;

    #[ORM\Column(length: 255)]
    private ?string $email = null;

    #[ORM\Column(length: 255)]
    private ?string $address = null;

    #[ORM\Column(length: 255)]
    private ?string $tags = null;

    #[ORM\Column(length: 255)]
    private ?string $site = null;

    #[ORM\Column(length: 1000)]
    private ?string $coordinates = null;

    #[ORM\Column(length: 255)]
    private ?string $howToFind = null;

    /**
     * @var Collection<int, Kitchens>
     */
    #[ORM\ManyToMany(targetEntity: Kitchens::class, inversedBy: 'restaurants')]
    private Collection $kitchens;

    #[ORM\ManyToOne(inversedBy: 'restaurantsPreview')]
    private ?File $previewImage = null;

    #[ORM\ManyToOne(inversedBy: 'restaurantsDetail')]
    private ?File $detailImage = null;

    /**
     * @var Collection<int, File>
     */
    #[ORM\ManyToMany(targetEntity: File::class, inversedBy: 'restaurantsGallery')]
    private Collection $gallery;

    public function __construct()
    {
        $this->kitchens = new ArrayCollection();
        $this->gallery = new ArrayCollection();
    }

    public function getId(): ?string
    {
        return $this->id;
    }

    public function setId(string $id): static
    {
        $this->id = $id;

        return $this;
    }

    public function isActive(): ?bool
    {
        return $this->active;
    }

    public function setActive(bool $active): static
    {
        $this->active = $active;

        return $this;
    }

    public function getSort(): ?int
    {
        return $this->sort;
    }

    public function setSort(int $sort): static
    {
        $this->sort = $sort;

        return $this;
    }

    public function getCreatedAt(): ?DateTimeImmutable
    {
        return $this->createdAt;
    }

    public function setCreatedAt(DateTimeImmutable $createdAt): static
    {
        $this->createdAt = $createdAt;

        return $this;
    }

    public function getUpdateAt(): ?DateTimeImmutable
    {
        return $this->updateAt;
    }

    public function setUpdateAt(DateTimeImmutable $updateAt): static
    {
        $this->updateAt = $updateAt;

        return $this;
    }

    public function getType(): ?RestaurantTypes
    {
        return $this->type;
    }

    public function setType(?RestaurantTypes $type): static
    {
        $this->type = $type;

        return $this;
    }

    public function getSettlement(): ?Settlements
    {
        return $this->settlement;
    }

    public function setSettlement(?Settlements $settlement): static
    {
        $this->settlement = $settlement;

        return $this;
    }

    public function getName(): ?string
    {
        return $this->name;
    }

    public function setName(string $name): static
    {
        $this->name = $name;

        return $this;
    }

    public function getCode(): ?string
    {
        return $this->code;
    }

    public function setCode(string $code): static
    {
        $this->code = $code;

        return $this;
    }

    public function getDescription(): ?string
    {
        return $this->description;
    }

    public function setDescription(string $description): static
    {
        $this->description = $description;

        return $this;
    }

    public function getReceipt(): ?string
    {
        return $this->receipt;
    }

    public function setReceipt(string $receipt): static
    {
        $this->receipt = $receipt;

        return $this;
    }

    public function getReceiptInfo(): ?string
    {
        return $this->receiptInfo;
    }

    public function setReceiptInfo(string $receiptInfo): static
    {
        $this->receiptInfo = $receiptInfo;

        return $this;
    }

    public function getPhone(): ?string
    {
        return $this->phone;
    }

    public function setPhone(string $phone): static
    {
        $this->phone = $phone;

        return $this;
    }

    public function getEmail(): ?string
    {
        return $this->email;
    }

    public function setEmail(string $email): static
    {
        $this->email = $email;

        return $this;
    }

    public function getAddress(): ?string
    {
        return $this->address;
    }

    public function setAddress(string $address): static
    {
        $this->address = $address;

        return $this;
    }

    public function getTags(): ?string
    {
        return $this->tags;
    }

    public function setTags(string $tags): static
    {
        $this->tags = $tags;

        return $this;
    }

    public function getSite(): ?string
    {
        return $this->site;
    }

    public function setSite(string $site): static
    {
        $this->site = $site;

        return $this;
    }

    public function getCoordinates(): string
    {
        return $this->coordinates;
    }

    public function setCoordinates(string $coordinates): static
    {
        $this->coordinates = $coordinates;

        return $this;
    }

    public function getHowToFind(): ?string
    {
        return $this->howToFind;
    }

    public function setHowToFind(string $howToFind): static
    {
        $this->howToFind = $howToFind;

        return $this;
    }

    /**
     * @return Collection<int, Kitchens>
     */
    public function getKitchens(): Collection
    {
        return $this->kitchens;
    }

    public function addKitchen(Kitchens $kitchen): static
    {
        if (!$this->kitchens->contains($kitchen)) {
            $this->kitchens->add($kitchen);
        }

        return $this;
    }

    public function removeKitchen(Kitchens $kitchen): static
    {
        $this->kitchens->removeElement($kitchen);

        return $this;
    }

    public function getPreviewImage(): ?File
    {
        return $this->previewImage;
    }

    public function setPreviewImage(?File $previewImage): static
    {
        $this->previewImage = $previewImage;

        return $this;
    }

    public function getDetailImage(): ?File
    {
        return $this->detailImage;
    }

    public function setDetailImage(?File $detailImage): static
    {
        $this->detailImage = $detailImage;

        return $this;
    }

    /**
     * @return Collection<int, File>
     */
    public function getGallery(): Collection
    {
        return $this->gallery;
    }

    public function addGallery(File $gallery): static
    {
        if (!$this->gallery->contains($gallery)) {
            $this->gallery->add($gallery);
        }

        return $this;
    }

    public function removeGallery(File $gallery): static
    {
        $this->gallery->removeElement($gallery);

        return $this;
    }

    #[ORM\PrePersist]
    public function setCreatedAtValue(): void
    {
        $this->createdAt = new DateTimeImmutable();
        $this->updateAt = new DateTimeImmutable();
    }

    #[ORM\PreUpdate]
    public function setUpdateAtValue(): void
    {
        $this->updateAt = new DateTimeImmutable();
    }
}
