<?php

namespace App\Shared\DtoFactory;

use App\Shared\Dto\PaginationDto;

class PaginationDtoFactory
{
    public function create(int $page, int $limit, int $total): PaginationDto
    {
        $pages = ceil($total / $limit);
        $page = ($page > 1) && ($page <= $pages) ? $page : 1;

        return new PaginationDto($page, $pages, $limit);
    }
}
