<?php

namespace App\Restaurants\Request;

use App\Shared\Abstraction\AbstractRequest;
use Symfony\Component\Validator\Constraints\All;
use Symfony\Component\Validator\Constraints\Type;
use Symfony\Component\Validator\Constraints\Uuid;
use Symfony\Contracts\Service\Attribute\Required;

class RestaurantFullUpdateRequest extends AbstractRequest
{
    #[Uuid]
    #[Required]
    public $id;

    #[Type('bool')]
    #[Required]
    public $active;

    #[Type('string')]
    #[Required]
    public $name;

    #[Type('string')]
    #[Required]
    public $description;

    #[Type('string')]
    #[Required]
    public $code;

    #[Type('string')]
    #[Required]
    public $receipt;

    #[Type('string')]
    #[Required]
    public $receipt_info;

    #[Type('array')]
    #[All(
        new Type('string')
    )]
    #[Required]
    public $phone;

    #[Type('array')]
    #[All(
        new Type('string')
    )]
    #[Required]
    public $email;

    #[Type('array')]
    #[All(
        new Type('string')
    )]
    #[Required]
    public $address;

    #[Type('array')]
    #[All([
        new Type('array'),
        new All(
            new Type('string')
        )
    ])]
    #[Required]
    public $tags;

    #[Type('string')]
    #[Required]
    public $site;

    #[Type('string')]
    #[Required]
    public $coordinates;

    #[Type('string')]
    #[Required]
    public $how_to_find;

    #[Uuid]
    public $type_id;

    #[Uuid]
    public $settelement_id;

    #[Uuid]
    public $preview_image_id;

    #[Uuid]
    public $detail_inage_id;

    #[Uuid]
    public $kitchens_id;

    #[Required]
    #[Type('array')]
    #[All(
        new UUid(),
    )]
    public $gallery;
}