<?php

namespace App\Restaurants\DtoFactory;

use App\Restaurants\Collection\RestaurantTypeCollection;
use App\Restaurants\Dto\RestaurantTypeDto;
use App\Shared\Entity\RestaurantTypes;
use Ramsey\Collection\Collection;

class RestaurantTypeDtoFactory
{
    public function create(RestaurantTypes $type): RestaurantTypeDto
    {
        return new RestaurantTypeDto(
            id: $type->getId(),
            name: $type->getName(),
            code: $type->getCode(),
        );
    }

    /**
     * @param Collection<RestaurantTypes> $types
     * @return RestaurantTypeCollection<RestaurantTypeDto>
     */
    public function createCollection(Collection $types): RestaurantTypeCollection
    {
        $typesDto = $types->map(function(RestaurantTypes $type) {
            return $this->create($type);
        });

        return new RestaurantTypeCollection(
            $typesDto->toArray()
        );
    }
}
