<?php

namespace App\Restaurants\Controller;

use App\Restaurants\UseCase\RestaurantGetListingUseCase;
use App\Restaurants\Request\RestaurantDetailRequest;
use App\Restaurants\Request\RestaurantListingRequest;
use App\Restaurants\UseCase\RestaurantGetDetailUseCase;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\Routing\Attribute\Route;

#[Route('/api/v1/restaurants')]
class RestaurantsController extends AbstractController
{
    public function __construct(
        private readonly RestaurantGetListingUseCase $getListingUseCase,
        private readonly RestaurantGetDetailUseCase $getDetailUseCase,
    ) {
    }

    #[Route('/', name: 'restaurants', methods: ['GET'])]
    public function restaurants(RestaurantListingRequest $request): JsonResponse
    {
        return $this->getListingUseCase->execute($request);
    }

    #[Route('/{detailId}', name: 'restaurant', methods: ['GET'])]
    public function restaurant(RestaurantDetailRequest $request): JsonResponse
    {
        return $this->getDetailUseCase->execute($request);
    }
}
