<?php

namespace App\News\Controller;

use App\News\Request\NewsCreateRequest;
use App\News\Request\NewsDetailRequest;
use App\News\Request\NewsFullUpdateRequest;
use App\News\Request\NewsListingRequest;
use App\News\Request\NewsPartUpdateRequest;
use App\News\UseCase\NewsCreateUseCase;
use App\News\UseCase\NewsDeleteUseCase;
use App\News\UseCase\NewsFullUpdateUseCase;
use App\News\UseCase\NewsGetDetailMainUseCase;
use App\News\UseCase\NewsGetDetailUseCase;
use App\News\UseCase\NewsGetListingUseUseCase;
use App\News\UseCase\NewsGetMainUseCase;
use App\News\UseCase\NewsPartUpdateUseCase;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Attribute\Route;

#[Route('/api/v1/news')]
class NewsController extends AbstractController
{
    public function __construct(
        private readonly NewsGetListingUseUseCase $getListingUseCase,
        private readonly NewsGetDetailUseCase $getDetailNews,
        private readonly NewsGetMainUseCase $getMainNews,
        private readonly NewsGetDetailMainUseCase $getDetailMainNews,
        private readonly NewsCreateUseCase $createNews,
        private readonly NewsFullUpdateUseCase $fullUpdate,
        private readonly NewsPartUpdateUseCase $partUpdate,
        private readonly NewsDeleteUseCase $delete,
    ) {
    }

    #[Route('/', name: 'news', methods: ['GET'])]
    public function news(NewsListingRequest $request): JsonResponse
    {
        return $this->getListingUseCase->execute($request);
    }

    #[Route('/mainNews', name: 'mainNews', methods: ['GET'])]
    public function mainNews(): JsonResponse
    {
        return $this->getMainNews->execute();
    }

    #[Route('/search', name: 'searchNews', methods: ['GET'])]
    public function detailMainNews(): JsonResponse
    {
        return $this->getDetailMainNews->execute();
    }

    #[Route('/{detailId}', name: 'oneNews', methods: ['GET'])]
    public function oneNews(NewsDetailRequest $request): JsonResponse
    {
        return $this->getDetailNews->execute($request);
    }

    #[Route('/create', name: 'createNews', methods: ['POST'])]
    public function createNews(NewsCreateRequest $request): Response
    {
        return $this->createNews->execute($request);
    }

    #[Route('/update', name: 'updateNews', methods: ['PUT'])]
    public function fillUpdateNews(NewsFullUpdateRequest $request): Response
    {
        return $this->fullUpdate->execute($request);
    }

    #[Route('/partUpdate', name: 'partUpdateNews', methods: ['PATCH'])]
    public function partUpdateNews(NewsPartUpdateRequest $request): Response
    {
        return $this->partUpdate->execute($request);
    }

    #[Route('/delete/{detailId}', name: 'deleteNews', methods: ['DELETE'])]
    public function deleteNews(NewsDetailRequest $request): Response
    {
        return $this->delete->execute($request);
    }
}
