<?php

namespace App\Shared\Request;

use App\Shared\Abstraction\AbstractRequest;
use Symfony\Component\Validator\Constraints\Uuid;
use Symfony\Contracts\Service\Attribute\Required;

class DetailRequest extends AbstractRequest
{
    #[Required]
    #[Uuid]
    public $detailId;

    protected function populate(): void
    {
        $requestUrl = $this->getRequest()->getUri();
        $index = strrpos($requestUrl, "/") + 1;

        $detailId = substr($requestUrl, $index);

        if (property_exists($this, "detailId")) {
            $this->{"detailId"} = $detailId;
        }
    }
}
