<?php

namespace App\Shared\Error;

use Symfony\Component\HttpKernel\Exception\HttpException;

class BaseError extends HttpException
{
    public function __construct(
        int $statusCode = 500,
        string $message = 'Something bad happening',
        ErrorCode $code = ErrorCode::NotExcepted
    ) {
        parent::__construct(
            statusCode: $statusCode,
            message: $message,
            code: $code->value
        );
    }
}
