<?php

namespace App\Shared\Abstraction;

use App\Shared\Dto\ErrorDto;
use App\Shared\DtoFactory\ErrorDtoFactory;
use App\Shared\Error\BaseError;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController as BundleController;
use Symfony\Component\HttpFoundation\JsonResponse;
use Throwable;

abstract class AbstractController extends BundleController
{
    public function __construct(
        protected readonly ErrorDtoFactory $errorFactory,
    ) {}

    protected function handle(ServiceInterface $service, AbstractRequest $request): JsonResponse
    {
//        try {
            return new JsonResponse($service->serve($request));
//
//        } catch (BaseError $error) {
//            $errorDto = $this->errorFactory->create($error);
//
//            return new JsonResponse($errorDto, $errorDto->status);
//
//        } catch (Throwable $exception) {
//            $error = new ErrorDto();
//            return new JsonResponse($error, $error->status);
//        }
    }
}
