<?php

namespace App\Restaurants\Service;

use App\Restaurants\DtoFactory\RestaurantDetailElementDtoFactory;
use App\Shared\Abstraction\DtoInterface;
use App\Shared\Abstraction\AbstractRequest;
use App\Shared\Abstraction\ServiceInterface;
use App\Shared\Error\NotFoundError;
use App\Shared\Repository\RestaurantsRepository;

class RestaurantDetailService implements ServiceInterface
{
    public function __construct(
        private readonly RestaurantsRepository $restaurants,

        private readonly RestaurantDetailElementDtoFactory $dtoFactory
    ) {}

    /**
     * @throws NotFoundError При ненайдемом ресторане
     * @throws \JsonException При ошибке парсинга списков
     */
    public function serve(AbstractRequest $request): DtoInterface
    {
        $restaurant = $this->restaurants->find($request->detailId);

        if ($restaurant === null) {
            throw new NotFoundError('Restaurant not found');
        }

        return $this->dtoFactory->create($restaurant);
    }
}
