<?php

namespace App\Restaurants\Request;

use App\Shared\Abstraction\AbstractRequest;
use Symfony\Component\Validator\Constraints\AtLeastOneOf;
use Symfony\Component\Validator\Constraints\Blank;
use Symfony\Component\Validator\Constraints\Uuid;

class RestaurantListingRequest extends AbstractRequest
{
    public $page = 1;

    public $limit = 12;

    #[AtLeastOneOf([
        new Uuid(),
        new Blank()
    ])]
    public $restaurant_type_id;
    #[AtLeastOneOf([
        new Uuid(),
        new Blank()
    ])]
    public $kitchen_id;

    protected function populate(): void
    {
        $request = $this->getRequest();
        foreach ($request->query->getIterator() as $property => $value) {
            if (property_exists($this, $property)) {
                $this->{$property} = $value;
            }
        }
    }
}
