<?php

namespace App\Restaurants\DtoFactory;

use App\Restaurants\Dto\RestaurantTypeDto;
use App\Shared\Dto\DtoCollection;
use App\Shared\Entity\RestaurantTypes;
use Ramsey\Collection\Collection;

class RestaurantTypeDtoFactory
{
    public function create(RestaurantTypes $type): RestaurantTypeDto
    {
        return new RestaurantTypeDto(
            id: $type->getId(),
            name: $type->getName(),
            code: $type->getCode(),
        );
    }

    /**
     * @param Collection<RestaurantTypes> $types
     * @return DtoCollection<RestaurantTypeDto>
     */
    public function createCollection(Collection $types): DtoCollection
    {
        $typesDto = $types->map(function(RestaurantTypes $type) {
            return $this->create($type);
        });

        return new DtoCollection(
            RestaurantTypeDto::class,
            $typesDto->toArray()
        );
    }
}
