<?php

namespace App\Restaurants\Dto;

use App\Shared\Abstraction\DtoInterface;
use App\Shared\Dto\DtoCollection;
use App\Shared\Dto\PaginationDto;

class RestaurantListDto implements DtoInterface
{
    /**
     * @param PaginationDto $pagination
     * @param DtoCollection<RestaurantListingElementDto> $list
     * @param RestaurantFilterVariantsDto $filterVariants
     */
    public function __construct(
        public PaginationDto $pagination,

        public DtoCollection $list,

        public RestaurantFilterVariantsDto $filterVariants,
    ) {}
}
