<?php

namespace App\Restaurants\Dto;

use App\Shared\Abstraction\DtoInterface;
use App\Shared\Dto\DtoCollection;
use App\Shared\Dto\FileDto;

class RestaurantDetailElementDto implements DtoInterface
{
    /**
     * @param string $id
     * @param string $name
     * @param string $code
     * @param string $coordinates
     * @param RestaurantTypeDto $type
     * @param string|null $check
     * @param string|null $check_info
     * @param DtoCollection<KitchenTypeDto>|null $kitchen
     * @param DtoCollection<string>|null $phone
     * @param DtoCollection<string>|null $email
     * @param DtoCollection<string>|null $address
     * @param DtoCollection<TagDto>|null $tags
     * @param string|null $site
     * @param FileDto|null $image Превью
     * @param DtoCollection<FileDto>|null $gallery
     */
    public function __construct(
        public string $id,

        public string $name,

        public string $code,

        public string $coordinates,

        public RestaurantTypeDto $type,

        public ?string $check = null,

        public ?string $check_info = null,

        public ?DtoCollection $kitchen = null,

        public ?DtoCollection $phone = null,

        public ?DtoCollection $email = null,

        public ?DtoCollection $address = null,

        public ?DtoCollection $tags = null,

        public ?string $site = null,

        public ?FileDto $image = null,

        public ?DtoCollection $gallery = null,
    ) {}
}
