<?php

namespace App\News\Service;

use App\News\DtoFactory\NewsCategoryDtoFactory;
use App\News\DtoFactory\NewsFilterVariantsDtoFactory;
use App\News\DtoFactory\NewsListDtoFactory;
use App\News\DtoFactory\NewsListingElementDtoFactory;
use App\Shared\DtoFactory\PaginationDtoFactory;
use App\News\Dto\NewsListDto;
use App\Shared\Abstraction\AbstractRequest;
use App\Shared\Abstraction\ServiceInterface;
use App\Shared\Repository\NewsCategoriesRepository;
use App\Shared\Repository\NewsRepository;

class NewsListingService implements ServiceInterface
{
    public function __construct(
        private readonly NewsRepository $news,
        private readonly NewsCategoriesRepository $newsCategories,

        private readonly PaginationDtoFactory $paginationFactory,
        private readonly NewsListingElementDtoFactory $listFactory,
        private readonly NewsFilterVariantsDtoFactory $filterFactory,
        private readonly NewsListDtoFactory $listingFactory,
        private readonly NewsCategoryDtoFactory $categoryFactory,
    ) {}

    public function serve(AbstractRequest $request): NewsListDto
    {
        $countOfNews = $this->news->getCountWithFilters($request->news_category);

        $pagination = $this->paginationFactory->create(
            $request->page,
            $request->limit,
            $countOfNews
        );

        $offset = min($pagination->pageSize, $countOfNews) * ($pagination->currentPage - 1);

        $list = $this->listFactory->createCollection(
            $this->news->getWithFilters($request->news_category, $request->limit, $offset)
        );

        $categoriesDto = $this->categoryFactory->createCollection(
            $this->newsCategories->getAll()
        );

        $filters = $this->filterFactory->create($categoriesDto);

        return $this->listingFactory->create(
            $pagination,
            $list,
            $filters
        );
    }
}
