<?php

namespace App\News\DtoFactory;

use App\News\Dto\NewsListingElementDto;
use App\Shared\Dto\DtoCollection;
use App\Shared\DtoFactory\FileDtoFactory;
use App\Shared\Entity\News;
use Ramsey\Collection\Collection;

class NewsListingElementDtoFactory
{
    public function __construct(
        private readonly FileDtoFactory $fileFactory,
    ) {}

    public function create(News $news): NewsListingElementDto
    {
        return new NewsListingElementDto(
            id: $news->getId(),
            name: $news->getName(),
            createAt: $news->getCreatedAt()->format('Y-m-d H:i:s'),
            detailLink: "api/v1/news/" . $news->getId(),
            description: $news->getPreviewText(),
            image: $news->getPreviewImage() !== null
                ? $this->fileFactory->create($news->getPreviewImage())
                :null,
        );
    }

    /**
     * @param Collection<News> $news
     * @return DtoCollection<NewsListingElementDto>
     */
    public function createCollection(Collection $news): DtoCollection
    {
        return new DtoCollection(
            NewsListingElementDto::class,
            $news->map(function(News $oneNews) {
                return $this->create($oneNews);
            })
            ->toArray()
        );
    }
}
