<?php

namespace App\News\DtoFactory;

use App\News\Dto\NewsDetailElementDto;
use App\Shared\DtoFactory\FileDtoFactory;
use App\Shared\Entity\News;

class NewsDetailElementDtoFactory
{
    public function __construct(
        private readonly FileDtoFactory $fileFactory
    ) {}

    public function create(News $news): NewsDetailElementDto
    {
        return new NewsDetailElementDto(
            id: $news->getId(),
            name: $news->getName(),
            description: $news->getPreviewText(),
            createAt: $news->getCreatedAt()->format('Y-m-d H:i:s'),
            text: $news->getDetailText(),
            image: $news->getPreviewImage() !== null
                ? $this->fileFactory->create($news->getPreviewImage())
                : null,
        );
    }
}
