<?php

namespace App\News\DtoFactory;

use App\News\Dto\NewsCategoryDto;
use App\Shared\Dto\DtoCollection;
use App\Shared\Entity\NewsCategories;
use Ramsey\Collection\Collection;

class NewsCategoryDtoFactory
{
    public function create(NewsCategories $category): NewsCategoryDto
    {
        return new NewsCategoryDto(
            id: $category->getId(),
            name: $category->getName(),
            code: $category->getCode(),
        );
    }

    /**
     * @param Collection<NewsCategories> $categories
     * @return DtoCollection<NewsCategoryDto>
     */
    public function createCollection(Collection $categories): DtoCollection
    {
        $categoriesDto = $categories->map(function(NewsCategories $category) {
            return $this->create($category);
        });

        return new DtoCollection(
            NewsCategoryDto::class,
            $categoriesDto->toArray()
        );
    }
}
