<?php

namespace App\News\Controller;

use App\News\Request\NewsListingRequest;
use App\News\Service\NewsDetailService;
use App\News\Service\NewsListingService;
use App\News\Service\NewsMainNewsService;
use App\News\Service\NewsSearchService;
use App\Shared\Abstraction\AbstractController;
use App\Shared\DtoFactory\ErrorDtoFactory;
use App\Shared\Request\DetailRequest;
use App\Shared\Request\EmptyRequest;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\Routing\Attribute\Route;

#[Route('/api/v1/news')]
class NewsController extends AbstractController
{
    public function __construct(
        ErrorDtoFactory $errorFactory,

        private readonly NewsDetailService $detailService,
        private readonly NewsListingService $listingService,
        private readonly NewsMainNewsService $mainNewsService,
        private readonly NewsSearchService $searchService,
    ) {
        parent::__construct($errorFactory);
    }

    #[Route('/', name: 'news', methods: ['GET'])]
    public function news(NewsListingRequest $request): JsonResponse
    {
        return $this->handle($this->listingService, $request);
    }

    #[Route('/mainNews', name: 'mainNews', methods: ['GET'])]
    public function mainNews(EmptyRequest $request): JsonResponse
    {
        return $this->handle($this->mainNewsService, $request);
    }

    #[Route('/search', name: 'searchNews', methods: ['GET'])]
    public function search(EmptyRequest $request): JsonResponse
    {
        return $this->handle($this->searchService, $request);
    }

    #[Route('/{detailId}', name: 'oneNews', methods: ['GET'])]
    public function oneNews(DetailRequest $request): JsonResponse
    {
        return $this->handle($this->detailService, $request);
    }
}
