<?php

namespace App\Shared\Repository;

use App\Shared\Entity\News;
use Doctrine\Bundle\DoctrineBundle\Repository\ServiceEntityRepository;
use Doctrine\ORM\Query\Expr\Join;
use Doctrine\ORM\QueryBuilder;
use Doctrine\Persistence\ManagerRegistry;
use Ramsey\Collection\Collection;

/**
 * @extends ServiceEntityRepository<News>
 *
 * @method News|null find($id, $lockMode = null, $lockVersion = null)
 * @method News|null findOneBy(array $criteria, array $orderBy = null)
 * @method News[]    findAll()
 * @method News[]    findBy(array $criteria, array $orderBy = null, $limit = null, $offset = null)
 */
class NewsRepository extends ServiceEntityRepository
{
    public function __construct(ManagerRegistry $registry)
    {
        parent::__construct($registry, News::class);
    }

    public function getMainNews(): News
    {
        return $this->createQueryBuilder('n')
            ->andWhere('n.mainPageRender = true')
            ->setMaxResults(1)
            ->getQuery()
            ->getResult()[0];
    }

    public function getCountWithFilters(?string $categoryId): int
    {
        $query = $this->createQueryBuilder('n');
        $query = $this->findByFilters($categoryId, $query);
        return $query->select('COUNT(n.id)')->getQuery()->getSingleScalarResult();
    }

    /** @return Collection<News> */
    public function getWithFilters(?string $categoryId, int $limit, int $offset): Collection
    {
        $query = $this->createQueryBuilder('n');
        $query = $this->findByFilters($categoryId, $query);
        $query = $query->setMaxResults($limit);
        $query = $query->setFirstResult($offset);
        return $this->toCollection($query);
    }

    /** @return Collection<News> */
    public function getAll(): Collection
    {
        return $this->toCollection($this->createQueryBuilder('n'));
    }

    /**
     * @param QueryBuilder $query
     * @return Collection<News>
     */
    protected function toCollection(QueryBuilder $query): Collection
    {
        return new Collection(
            News::class,
            $query
                ->orderBy('n.sort', 'ASC')
                ->getQuery()
                ->getResult()
        );
    }

    protected function findByFilters(?string $categoryId, QueryBuilder $query): QueryBuilder
    {
        if ($categoryId !== null) {
            $query = $query
                ->innerJoin('n.categories', 'c', Join::WITH, 'c.id = :typeId')
                ->setParameter('typeId', $categoryId);
        }
        return $query;
    }
}
