<?php

namespace App\Repository;
use Exception;
use Generator;

/**
 * Принимает путь до файла,
 * проверяет, что файл существует и выводит пользователю построчный вывод используя yield
 *
 * @param string $filePath путь до файла
 * @return Generator
 * @throws Exception если казанного фала нет
 */
function readFileLineByLine(string $filePath): Generator
{
    if (!file_exists($filePath)){
        throw new Exception("неверный путь");
    }

    $file = fopen($filePath, 'r');
    while (!feof($file)){
        yield fgets($file);
    }
    fclose($file);
}
