<?php

namespace App\Actions;

use Exception;

class ReadLogFileAction
{
    /**
     * Принимает путь до файла,
     * проверяет, что файл существует и выводит пользователю весь контент файла
     * (файл можешь создать любой)
     *
     * @param string $filePath путь до файла
     * @return false|string
     * @throws Exception при отсутсвии фаила по переданному пути
     */
    public function act(string $filePath)
    {
        if (!file_exists($filePath)) {
            throw new Exception("По данному пути ничего не найдено: $filePath");
        }

        return file_get_contents($filePath);
    }
}
