<?php

namespace App\Controller;

use App\Actions\SortPriceAction;
use App\Entity\PricesEntity;
use App\Service\ValidationService;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\Routing\Attribute\Route;

class SortPriceController extends AbstractController
{
    /**
     * Контроллер волняет сортировку массива по убыванию цены используя sortPrice
     * @param Request $request
     * @param SortPriceAction $action
     * @return JsonResponse
     */
    #[Route('/sort/price', name: 'app_sort_price', methods: ['POST'])]
    public function index(Request $request, SortPriceAction $action): JsonResponse
    {
        $priceEntity = new PricesEntity();
        $priceEntity->serialise($request);

        $validation = new ValidationService();
        $validation->validate($priceEntity);

        return new JsonResponse($action->act($priceEntity));
    }
}
