<?php

namespace App\News\UseCase;

use App\News\Service\NewsPrepareResponseService;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\Response;
use Throwable;

class NewsGetMainUseCase
{
    public function __construct(
        private readonly NewsPrepareResponseService  $responsePrepareService,
    ) {}

    public function execute(): JsonResponse
    {
        try {
            return new JsonResponse(
                $this->responsePrepareService->bornMainNews()
            );
        } catch (Throwable) {
            return new JsonResponse([], Response::HTTP_INTERNAL_SERVER_ERROR);
        }
    }
}