<?php

namespace App\News\DtoFactory;

use App\News\Dto\NewsFilterVariantsDto;
use App\News\Dto\NewsListDto;
use App\Shared\Collection\ListingCollection;
use App\Shared\Dto\PaginationDto;

class NewsListDtoFactory
{
    public function create(
        PaginationDto $pagination,
        ListingCollection $list,
        NewsFilterVariantsDto $filters,
    ): NewsListDto {
        return new NewsListDto(
            pagination: $pagination,
            list: $list,
            filterVariants: $filters
        );
    }
}
