<?php

namespace App\Tests\DataFixtures;

use App\Shared\Entity\File;
use App\Shared\Entity\Kitchens;
use App\Shared\Entity\Restaurants;
use App\Shared\Entity\RestaurantTypes;
use DateTimeImmutable;
use Doctrine\Bundle\FixturesBundle\Fixture;
use Doctrine\Persistence\ObjectManager;

class RestaurantFixture extends Fixture
{

    /**
     * @param ObjectManager $manager
     * @return mixed
     */
    public function load(ObjectManager $manager)
    {
        $type = new RestaurantTypes();
        $type->setId('00000000-0000-0000-0000-000000000000');
        $type->setName('Type1');
        $type->setCode('type_1');
        $manager->persist($type);

        $type = new RestaurantTypes();
        $type->setId('00000000-0000-0000-0000-000000000001');
        $type->setName('Type2');
        $type->setCode('type_2');
        $manager->persist($type);

        $kitchen = new Kitchens();
        $kitchen->setId('00000000-0000-0000-0000-000000000000');
        $kitchen->setName('Kitchen1');
        $kitchen->setCode('kitchen_1');
        $manager->persist($kitchen);

        $image = new File();
        $image->setId('00000000-0000-0000-0000-000000000001');
        $image->setName('image1');
        $image->setDescription('description');
        $image->setSize(512);
        $image->setType('jpg');
        $image->setUrl("/here/");
        $manager->persist($image);

        $restaurant = new Restaurants();
        $restaurant->setId('00000000-0000-0000-0000-000000000000');
        $restaurant->setName('Restaurant1');
        $restaurant->setCode('restaurant_1');
        $restaurant->setActive(true);
        $restaurant->setSort(1);
        $restaurant->setCreatedAt(new DateTimeImmutable('now'));
        $restaurant->setUpdateAt(new DateTimeImmutable('now'));
        $restaurant->setDescription('Description');
        $restaurant->setReceipt('check1');
        $restaurant->setReceiptInfo('check1Info');
        $restaurant->setPhone('{"phone1": "+7000000000"}');
        $restaurant->setEmail('{"email": "base@gmail.com"}');
        $restaurant->setAddress('{"address": "somewhere"}');
        $restaurant->setTags('{"setTags1": ["tag1", "tag2", "tag3"], "setTags2": ["tag1", "tag2", "tag3"]}');
        $restaurant->setSite('www.restaurant.ru');
        $restaurant->setCoordinates("0.0.0.0");
        $restaurant->setHowToFind('just open thw map!');
        $restaurant->addKitchen($kitchen);
        $restaurant->setType($type);
        $restaurant->setPreviewImage($image);
        $manager->persist($restaurant);



        $manager->flush();
    }
}