<?php

namespace App\Restaurants\UseCase;

use App\News\Request\NewsPartUpdateRequest;
use App\News\Service\NewsPrepareResponseService;
use App\Restaurants\Request\RestaurantPartUpdateRequest;
use App\Restaurants\Service\RestaurantPrepareResponseService;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\Response;
use Throwable;

class RestaurantPartUpdateUseCase
{
    public function __construct(
        private readonly RestaurantPrepareResponseService $prepareRequestService,
    ) {
    }

    public function execute(RestaurantPartUpdateRequest $request): Response
    {
        try {
            $this->prepareRequestService->rebirth($request);
            return new Response();
        } catch (Throwable) {
            return new JsonResponse([], Response::HTTP_INTERNAL_SERVER_ERROR);
        }
    }
}
