<?php

namespace App\Restaurants\Request;

use App\Shared\Abstraction\AbstractRequest;
use Symfony\Component\Validator\Constraints\All;
use Symfony\Component\Validator\Constraints\Type;
use Symfony\Component\Validator\Constraints\Uuid;
use Symfony\Contracts\Service\Attribute\Required;

class RestaurantCreateRequest extends AbstractRequest
{
    #[Uuid]
    public $type_id;

    #[Uuid]
    public $settlement_id;

    #[Uuid]
    public $preview_image_id;

    #[Uuid]
    public $detail_image_id;

    #[Type('bool')]
    #[Required]
    public $active;

    #[Type('string')]
    #[Required]
    public $name;

    #[Type('string')]
    #[Required]
    public $code;

    #[Type('string')]
    #[Required]
    public $description;

    #[Type('string')]
    #[Required]
    public $check;

    #[Type('string')]
    #[Required]
    public $check_info;


    #[Type('string')]
    #[Required]
    public $phone;

    #[Type('string')]
    #[Required]
    public $email;

    #[Type('string')]
    #[Required]
    public $address;

    #[Type('string')]
    #[Required]
    public $tags;

    #[Type('string')]
    #[Required]
    public $site;

    #[Type('string')]
    #[Required]
    public $coordinates;

    #[Type('string')]
    #[Required]
    public $how_to_find;

    #[Type('array')]
    #[All(
        new UUid(),
    )]
    public $kitchens_id;

    #[Type('array')]
    #[All(
        new UUid(),
    )]
    public $gallery_id;
}
