<?php

namespace App\Restaurants\DtoFactory;

use App\Restaurants\Collection\RestaurantListingElementCollection;
use App\Restaurants\Dto\RestaurantListingElementDto;
use App\Shared\DtoFactory\FileDtoFactory;
use App\Shared\Entity\Restaurants;
use Ramsey\Collection\Collection;

class RestaurantListingElementDtoFactory
{
    public function __construct(
        private readonly RestaurantTypeDtoFactory $typeFactory,
        private readonly FileDtoFactory $fileFactory,
    ) {}
    public function create(Restaurants $restaurant): RestaurantListingElementDto
    {
        return new RestaurantListingElementDto(
            id: $restaurant->getId(),
            name: $restaurant->getName(),
            code: $restaurant->getCode(),
            type: $this->typeFactory->create($restaurant->getType()),
            detailLink: 'api/v1/restaurants/' . $restaurant->getId(),
            check: $restaurant->getReceipt(),
            image: $this->fileFactory->create($restaurant->getPreviewImage())
        );
    }

    /**
     * @param Collection<Restaurants> $restaurants
     * @return RestaurantListingElementCollection<RestaurantListingElementDto>
     */
    public function createCollection(Collection $restaurants): RestaurantListingElementCollection
    {
        $restaurantsDto = $restaurants->map(function(Restaurants $restaurant) {
            return $this->create($restaurant);
        });

        return new RestaurantListingElementCollection($restaurantsDto->toArray());
    }
}
