<?php

namespace App\News\UseCase;

use App\News\Request\NewsFullUpdateRequest;
use App\News\Service\NewsPrepareResponseService;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\Response;
use Throwable;

class NewsFullUpdateUseCase
{
    public function __construct(
        private readonly NewsPrepareResponseService $prepareRequestService,
    ) {
    }

    public function execute(NewsFullUpdateRequest $request): Response
    {
        try {
            $this->prepareRequestService->reborn($request);
            return new Response();
        } catch (Throwable) {
            return new JsonResponse([], Response::HTTP_INTERNAL_SERVER_ERROR);
        }
    }
}
