<?php

namespace App\News\UseCase;

use App\News\Request\NewsDetailRequest;
use App\News\Service\NewsPrepareResponseService;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\Response;
use Throwable;

class NewsDeleteUseCase
{
    public function __construct(
        private readonly NewsPrepareResponseService $prepareRequestService,
    ) {
    }

    public function execute(NewsDetailRequest $request): Response
    {
        try {
            $this->prepareRequestService->unbirth($request);
            return new Response();
        } catch (Throwable) {
            return new JsonResponse([], Response::HTTP_INTERNAL_SERVER_ERROR);
        }
    }
}
